/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.binary2;

import cds.savot.binary.Base64OutputStream;
import cds.savot.binary.SavotDataWriter;
import cds.savot.model.FieldSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class DataBinary2Writer
implements SavotDataWriter {
    private OutputStream output;
    private BinaryFieldInterpreter<?>[] encoders;

    public DataBinary2Writer(OutputStream rawStream, FieldSet fields) throws BinaryInterpreterException, IOException {
        this(rawStream, fields, null);
    }

    public DataBinary2Writer(OutputStream rawStream, FieldSet fields, String encoding) throws IOException {
        if (rawStream == null) {
            throw new NullPointerException("The given output stream is NULL !");
        }
        this.output = this.getEncodedStream(rawStream, encoding);
        int nFields = fields.getItemCount();
        this.encoders = new BinaryFieldInterpreter[nFields];
        for (int i = 0; i < nFields; ++i) {
            this.encoders[i] = BinaryFieldInterpreter.createInterpreter((SavotField)fields.getItemAt(i));
        }
    }

    OutputStream getEncodedStream(OutputStream rawStream, String encoding) throws IOException, BinaryInterpreterException {
        if (encoding == null || encoding.isEmpty()) {
            return rawStream;
        }
        if (encoding.equalsIgnoreCase("base64")) {
            return new Base64OutputStream(rawStream);
        }
        if (encoding.equalsIgnoreCase("gzip")) {
            return new GZIPOutputStream(rawStream);
        }
        if (encoding.equalsIgnoreCase("dynamic")) {
            return rawStream;
        }
        throw new BinaryInterpreterException("Unknown encoding \"" + encoding + "\" ! It must be either \"base64\" or \"gzip\" !");
    }

    @Override
    public void writeTR(SavotTR row) throws IOException, BinaryInterpreterException {
        if (this.output == null) {
            throw new IOException("Writer closed !");
        }
        TDSet tds = row.getTDSet();
        int len = tds.getItemCount();
        for (int i = 0; i < len; ++i) {
            SavotTD td = (SavotTD)tds.getItemAt(i);
            this.encoders[i].encode(this.output, td.getContent());
        }
    }

    @Override
    public void writeTRSet(TRSet rows) throws IOException, BinaryInterpreterException {
        if (this.output == null) {
            throw new IOException("Writer closed !");
        }
        int len = rows.getItemCount();
        for (int i = 0; i < len; ++i) {
            this.writeTR((SavotTR)rows.getItemAt(i));
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
        this.output = null;
        this.encoders = null;
    }
}

